<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BankAccount;
use App\Models\Bank;
use App\Traits\PaginatorHelper;
use Illuminate\Support\Facades\DB;

class BankAccountController extends Controller
{
    use PaginatorHelper;

    public function banks(Request $request)
    {
        return response()->json(Bank::orderBy('name', 'asc')->get());
    }

    public function index(Request $request)
    {
        $helper = $this->processRequest($request);
        $accounts = BankAccount::whereNotNull('id');
        $accounts->with('bank');
        $accounts = $this->applyFilters($accounts, $helper, ['type', 'number']);

        return response()->json($accounts);
    }

    public function all(Request $request)
    {
        return response()->json(BankAccount::with('bank')->get());
    }

    public function search(Request $request)
    {
        $number = $request->number;
        $account = BankAccount::where('number', $number)->first();

        if ($account) {
            return response()->json([
                "status" => 1,
                "item" => $account,
                "message" => "Cuenta Bancaria encontrado"
            ]);
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Cuenta Bancaria NO encontrada"
            ]);
        }
    }

    public function save(Request $request)
    {
        $id = $request->id;

        try{
            // Begin of the transaction
            DB::beginTransaction();
            if ($id) {
                $account = BankAccount::find($id);
            } else {
                $account = new BankAccount();
            }

            $account->number = $request->number;
            $account->type = $request->type;
            $account->bank_id = $request->bankId;

            $account->save();

            // Write in the database
            DB::commit();
            if ($account) {
                return response()->json([
                    "status" => 1,
                    "item" => $account,
                    "message" => "Cuenta Bancaria actualizada exitosamente"
                ]);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Cuenta Bancaria No encontrado"
                ]);
            }
        } catch(\Exception $e) {
            // Make a Rollback
            DB::rollback();

            // Return Response
            return response()->json([
                "status" => 0,
                "message" => $e
            ]);
        }
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        try{
            $account = BankAccount::find($id);
            $account->delete();
            return response()->json([
                "status" => 1,
                "message" => "Cuenta Bancaria ". $account->number . " eliminado exitosamente"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error, intente mas tarde, si el problema persiste comuniquese con su administrador"
            ]);
        }
    }
}
