<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Fare;

class FareController extends Controller
{
    public function all(Request $request)
    {
        return response()->json(Fare::with('vehicleType')->paginate(10));
    }

    public function index(Request $request)
    {
        $user = $request->user();
        if (!$user) {
            return response()->json([
                "status" => 0,
                "message" => "Usuario no autenticado"
            ], 401);
        }

        $turn = $user->profile->turns()->latest()->first();

        if (!$turn) {
            return response()->json([
                "status" => 0,
                "message" => "Usuario no tiene turno activo"
            ], 403);
        }

        $fares = Fare::with('vehicleType');

        if ($turn->workstation_id <= 2) {
            $fares->where('vehicle_type_id', 1);
        }

        return response()->json($fares->get());
    }

    public function search(Request $request)
    {
        $vehicleTypeId = $request->vehicleTypeId;
        $fare = Fare::where('vehicle_type_id', $vehicleTypeId)->first();
        if ($fare) {
            return response()->json([
                "status" => 1,
                "item" => $fare
            ]);
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Tarifa no encontrada"
            ]);
        }
    }

    public function save(Request $request)
    {
        $id = $request->id;
        $vehicleTypeId = $request->vehicleTypeId;
        $name = $request->name;
        $value = $request->value;
        try {
            $fare = Fare::find($id);
            if (!$fare) {
                return response()->json([
                    "status" => 0,
                    "message" => "Tarifa no encontrada"
                ]);
            }

            $fare->vehicle_type_id = $vehicleTypeId;
            $fare->name = $name;
            $fare->value = floatval($value);
            $fare->save();

            return response()->json([
                "status" => 1,
                "message" => "Tarifa actualizada exitosamente"
            ]);
        } catch (Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error en el servidor, intente mas tarde"
            ]);
        }
    }

    public function delete(Request $request)
    {
        $id = $request->id;
        try{
            $profile = Fare::find($id);
            $fare->delete();
            return response()->json([
                "status" => 1,
                "message" => "Tarifa ". $fare->name . " eliminado exitosamente"
            ]);

        } catch (\Exception $e) {
            return response()->json([
                "status" => 0,
                "message" => "Ocurrio un error, intente mas tarde, si el problema persiste comuniquese con su administrador"
            ]);
        }
    }
}
