<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PrepaidSummary;
use Illuminate\Support\Facades\DB;

class PrepaidSummaryController extends Controller
{
    public function cancelRecharge(Request $request)
    {
        $id = $request->id;
        $concept = $request->concept;
        if (empty($concept)){
            return response()->json([
                "status" => 0,
                "message" => "No se anulo la recarga. Debes indicar el motivo por el cual estas anulando la recarga"
            ]);
        }

        $recharge = PrepaidSummary::find($id);

        if (!$recharge) {
            return response()->json([
                "status" => 0,
                "message" => "No se encontro la recarga en la base de datos"
            ]);
        }

        try{
            DB::beginTransaction();

            $card = $recharge->prepaidCard;
            $card->balance = $card->balance - $recharge->amount;
            $card->save();

            $recharge->cancel_concept = $concept;
            $recharge->save();

            $summary = PrepaidSummary::create([
                "prepaid_card_id" => $card->id,
                "code" => $recharge->code,
                "type" => "out",
                "concept" => "Reverso en recarga " . $recharge->code,
                "amount" => $recharge->amount,
                "new_balance" => $card->balance
            ]);

            DB::commit();
            return response()->json([
                "status" => 1,
                "message" => 'Recarga anulada exitosamente'
            ]);

        } catch(\Exception $e) {
            // Make a Rollback
            DB::rollback();

            // Return Response
            return response()->json([
                "status" => 0,
                "message" => 'Ocurrio un error en el servidor, intente mas tarde'
            ]);
        }
    }
}
