<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class CheckAnsapassRequest
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // Sleep the thread
        $time = random_int(10000, 500000);
        usleep($time);

        // Obtain if ansapass thread is bloqued
        $bloqued = Cache::get('blockAnsapass');

        // If bloqued
        if ($bloqued) {
            return response()->json([
                "status" => 1,
                "date" => date('d/m/Y'),
                "time" => date('H:i:s'),
                "sticker" => $request->tag ?? 'omitido',
                "info" => "Operacion duplicada",
                "user" => "----",
                "balance" => "----"
            ]);
        }

        return $next($request);
    }
}
