<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\PrepaidCard;
use App\Models\PrepaidSummary;

class RebuildPrepaidSummariesJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $card;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(PrepaidCard $card)
    {
        $this->card = $card;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $balance = $this->card->balance;
        $summaries = PrepaidSummary::where('prepaid_card_id', $this->card->id)->orderBy('created_at', 'desc')->get();
        foreach ($summaries as $summary) {
            // Set the actual balance to the movement, because, is the new balance
            // in the movement
            $summary->new_balance = $balance;
            // and save it
            $summary->save();

            // now determine the next new balance for the next movement
            // the next new balance is the actual balance and reverse the
            // actual movement
            $ammount = $summary->amount;
            $multiplier = ($summary->type == 'out') ? -1 : 1;
            $ammount = $ammount * $multiplier;
            $balance -= $ammount;
        }
        echo 'Card ' .$this->card->id. ' processed</br>';
    }
}
