<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Models\PrepaidSummary;
use App\Models\Takings;

class ValidatePrepaidSummaryJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $prepaidSummary;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(PrepaidSummary $prepaidSummary)
    {
        $this->prepaidSummary = $prepaidSummary;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $taking = Takings::with('vehicle')->where('code', $this->prepaidSummary->code)->first();

        if (!$taking) {
            \Log::info($this->prepaidSummary->id . " Sin Recaudacion");
            return;
        }

        if (!$taking->vehicle) {
            \Log::info($this->prepaidSummary->id . " Sin vehiculo");
            return;
        }

        if ($taking->vehicle->profile_id == $this->prepaidSummary->prepaidCard->profile_id) {
            \Log::info($this->prepaidSummary->id . " Validado correctamente");
        } else {
            \Log::debug("Veriificar Cargo Prepagado " . $this->prepaidSummary->id);

        }
    }
}
