<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ansapass extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $with = ['vehicle'];

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'prepaid_card_id' => 'integer',
        'vehicle_id' => 'integer',
        'deleted_at' => 'timestamp',
    ];

    public function prepaidCard()
    {
        return $this->belongsTo(PrepaidCard::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }
}
