<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PrepaidCard extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array
     */
    protected $hidden = [
        // 'password',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'profile_id' => 'integer',
        'balance' => 'decimal:2',
        'exonerated' => 'boolean',
        'direct' => 'boolean',
        'status' => 'boolean',
        'deleted_at' => 'timestamp',
    ];

    public function vehicles()
    {
        return $this->belongsToMany(Vehicle::class);
    }

    public function ansapasses()
    {
        return $this->hasMany(Ansapass::class);
    }

    public function profile()
    {
        return $this->belongsTo(Profile::class);
    }

    public function prepaidSummaries()
    {
        return $this->hasMany(PrepaidSummary::class);
    }
}
