<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrepaidSummary extends Model
{
    use HasFactory;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'prepaid_card_id' => 'integer',
        'ansapass_id' => 'integer',
        'amount' => 'decimal:2',
        'tax' => 'decimal:2',
    ];

    public function payments()
    {
        return $this->morphToMany(Payment::class, 'paymentable');
    }

    public function prepaidCard()
    {
        return $this->belongsTo(PrepaidCard::class);
    }

    public function ansapass()
    {
        return $this->belongsTo(Ansapass::class);
    }
}
