<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vehicle extends Model
{
    use HasFactory;
    use SoftDeletes;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var array
     */
    protected $guarded = [];
    protected $with = ['profile'];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'profile_id' => 'integer',
        'vehicle_type_id' => 'integer',
        'vehicle_brand_id' => 'integer',
        'deleted_at' => 'timestamp',
    ];

    public function prepaidCards()
    {
        return $this->belongsToMany(PrepaidCard::class);
    }

    public function profile()
    {
        return $this->belongsTo(Profile::class);
    }

    public function vehicleType()
    {
        return $this->belongsTo(VehicleType::class);
    }

    public function vehicleBrand()
    {
        return $this->belongsTo(VehicleBrand::class);
    }

    public function ansapass()
    {
        return $this->hasOne(Ansapass::class);
    }
}
