<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Fare;
use App\Models\VehicleType;

class FareFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Fare::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'vehicle_type_id' => VehicleType::factory(),
            'name' => $this->faker->name,
            'value' => $this->faker->randomFloat(2, 0, 999999.99),
            'deleted_at' => $this->faker->dateTime(),
        ];
    }
}
