<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Ansapass;
use App\Models\PrepaidCard;
use App\Models\PrepaidSummary;

class PrepaidSummaryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = PrepaidSummary::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'prepaid_card_id' => PrepaidCard::factory(),
            'ansapass_id' => Ansapass::factory(),
            'code' => $this->faker->regexify('[A-Za-z0-9]{20}'),
            'type' => $this->faker->randomElement(["add","out"]),
            'concept' => $this->faker->regexify('[A-Za-z0-9]{100}'),
            'amount' => $this->faker->randomFloat(2, 0, 999999.99),
            'tax' => $this->faker->randomFloat(2, 0, 999999.99),
        ];
    }
}
