<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use App\Models\Profile;
use App\Models\Turn;
use App\Models\Workstation;

class TurnFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Turn::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'number' => $this->faker->numberBetween(-10000, 10000),
            'profile_id' => Profile::factory(),
            'workstation_id' => Workstation::factory(),
            'begin_at' => $this->faker->dateTime(),
            'end_at' => $this->faker->dateTime(),
        ];
    }
}
