<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
         Schema::disableForeignKeyConstraints();

        Schema::create('voltas', function (Blueprint $table) {
            $table->id();
            $table->string('create_by', 30);
            $table->decimal('received', 8, 2);
            $table->decimal('collected', 8, 2);
            $table->foreignId('turn_id')->constrained()->cascadeOnDelete()->cascadeOnUpdate()->nullable();
            $table->string('note', 255);
            $table->boolean('income'->default(0));
            $table->timestamps();
        });

        Schema::enableForeignKeyConstraints();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voltas');
    }
};
