<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Bank;

class BanksSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/banks.json');
        $json = json_decode($file);


        foreach ($json as $item) {
            Bank::create([
                'code' => $item->code,
                'name' => $item->name,
                'image' => 'no-image'
            ]);
        }
    }
}

