<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\PrepaidCard;
use Illuminate\Support\Facades\Hash;

class HashingPasswordCards extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get All the Prepaid Cards
        $cards = PrepaidCard::all();

        $index = 0;
        $total = count($cards);

        foreach ($cards as $card) {
            // Hash the password
            $card->password = Hash::make($card->password);
            // Save
            $card->save();

            $this->printProgress($total, $index);
            $index++;
        }
    }

    private function printProgress($total, $index): void
    {
        // Print progress every $steps%
        $steps = 50;
        $ratio = 50;
        $progress = round($index * 100 * $ratio / $total);
        if ( $progress % $steps == 0 ) {
            print('....'. ($progress / $ratio) .'%');
        }
        if($total == ($index + 1)) {
            print(PHP_EOL. PHP_EOL. '      FINISHED!!' . PHP_EOL. PHP_EOL);
        }
    }
}
