<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ProfileType;

class ProfileTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/profile-types-imported.json');
        $json = json_decode($file);

        foreach ($json as $item) {
            ProfileType::create([
                'name' => $item->name,
                'slug' => $item->slug,
                'description' => $item->description,
            ]);
        }
    }
}
