<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Profile;
use Illuminate\Support\Facades\Hash;

class UpdateCollectorPasswords extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/collector-passwords.json');
        $json = json_decode($file);

        $index = 0;
        $total = count($json);

        foreach ($json as $item) {
            $profile = Profile::with('user')->where('id_card', $item->idCard)->first();
            $profile->user->password = Hash::make($item->password);
            $profile->user->save();
            $this->printProgress($total, $index);
            $index++;
        }
    }

    private function printProgress($total, $index): void
    {
        // Print progress every $steps%
        $steps = 50;
        $ratio = 50;
        $progress = round($index * 100 * $ratio / $total);
        if ( $progress % $steps == 0 ) {
            print('....'. ($progress / $ratio) .'%');
        }
        if($total == ($index + 1)) {
            print(PHP_EOL. PHP_EOL. '      FINISHED!!' . PHP_EOL. PHP_EOL);

        }
    }
}
