<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Profile;
use App\Models\User;

class UpdateUsersInfoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/update-users.json');
        $json = json_decode($file);

        $total = count($json);
        foreach ($json as $item) {
            $profile = Profile::where('id_card', $this->sanitizeNumber($item->document))->first();
            if (!$profile){
                echo "NOT FOUND: " . $item->document. PHP_EOL;
                continue;
            }

            $user = $profile->user;
            $profile->names = $item->names;
            $profile->surnames = $item->surnames;
            $profile->phone = $item->phone;
            $profile->save();

            if ($item->email) {
                $check = User::where('email', $item->email)->first();
                if (!$check){
                    $user->email = $item->email;
                    $user->save();
                }
            }
        }
    }

    private function sanitizeNumber(string $number): string
    {
        $charsToClean = ['V', 'G', 'J', 'E', ' ', ',', '.', '-', 'v', 'g', 'j', 'e'];
        return str_replace($charsToClean, '', strtoupper($number));
    }
}
