<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\VehicleBrand;

class VehicleBrandSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/vehicle-brands.json');
        $json = json_decode($file);

        foreach ($json as $brand) {
            VehicleBrand::create([
                'id' => $brand->id,
                'name' => $brand->brand,
                'description' => $brand->brand,
                'logo' => $brand->slug . '.png',
            ]);
        }
    }
}
