<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Workstation;

class WorkstationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $file = file_get_contents('database/seeders/data/workstation-imported.json');
        $json = json_decode($file);

        foreach ($json as $item) {
            Workstation::create([
                'name' => $item->name,
                'description' => $item->description,
                'printer' => $item->printer
            ]);
        }
    }
}
