import Auth from '../layout/auth.vue'
import Guest from '../layout/guest.vue'

import MainLayout from '../layout/main-layout.vue'
import Login from './../pages/login.vue'
import Dashboard from './../pages/dashboard.vue'
import UserAdd from './../pages/users/users-add.vue'
import UserList from './../pages/users/users-list.vue'
import UserHistory from './../pages/users/users-history.vue'

import VehiclesAdd from './../pages/vehicles/vehicles-add.vue'
import VehiclesList from './../pages/vehicles/vehicles-list.vue'
import VehiclesBrands from './../pages/vehicles/vehicles-brands.vue'
import VehiclesModels from './../pages/vehicles/vehicles-models.vue'


import UnderConstruction from './../pages/under-construction.vue'

// import UserDashboard from './../Pages/User/Dashboard.vue'
// import Profile from './../Pages/User/Profile.vue'
// import About from './../Pages/About.vue'
// import Products from './../Pages/Products.vue'
// import Categories from './../Pages/Categories.vue'
// import Subcategories from './../Pages/Subcategories.vue'
// import Exit from './../Pages/Exit.vue'

// import Posts from './../Pages/Posts.vue'

// import ProductsTable from './../Components/Products/TableProducts2'
// import ProductsForm from './../Components/Products/FormProduct'

// import PostsTable from './../Components/Posts/PostsTable2'
// import PostsForm from './../Components/Posts/PostsForm2'

// import SlidesForm from './../Components/Slides/SlidesForm'
// import SlidesTable from './../Components/Slides/SlidesTable'

// import UserAddresses from './../Pages/User/Addresses.vue'

const routes = [
	{
		path: "/",
    	component: MainLayout,
    	redirect: 'login',
    	children: [
			{
				path: 'escritorio',
				name: 'dashboard',
				component: Dashboard,
			},
			{
				path: 'usuarios',
				children: [
					{
						path: 'nuevo',
						name: 'users-add',
						component: UserAdd,
					},
					{
						path: 'lista',
						name: 'users-list',
						component: UserList,
					},
					{
						path: 'historial',
						name: 'users-history',
						component: UserHistory,
					}
				]
			},
			{
				path: 'vehiculos',
				children: [
					{
						path: 'nuevo',
						name: 'vehicles-add',
						component: VehiclesAdd,
					},
					{
						path: 'lista',
						name: 'vehicles-list',
						component: VehiclesList,
					},
					{
						path: 'marcas',
						name: 'vehicles-brands',
						component: UnderConstruction,
					},
					{
						path: 'modelos',
						name: 'vehicles-models',
						component: UnderConstruction,
					},
				]
			},
			{
				path: 'ansapass',
				children: [
					{
						path: 'nuevo',
						name: 'ansapass-add',
						component: UnderConstruction,
					},
					{
						path: 'lista',
						name: 'ansapass-list',
						component: UnderConstruction,
					},
					{
						path: 'marcas',
						name: 'ansapass-history',
						component: UnderConstruction,
					}
				]
			},
			{
				path: 'carnets/prepagados',
				children: [
					{
						path: 'nuevo',
						name: 'prepaid-cards-add',
						component: UnderConstruction,
					},
					{
						path: 'lista',
						name: 'prepaid-cards-list',
						component: UnderConstruction,
					},
					{
						path: 'marcas',
						name: 'prepaid-cards-history',
						component: UnderConstruction,
					}
				]
			},
			{
				path: 'configuraciones',
				children: [
					{
						path: 'empresa',
						name: 'settings-company',
						component: UnderConstruction,
					},
					{
						path: 'cuentas/bancarias',
						name: 'settings-bank-accounts',
						component: UnderConstruction,
					},
					{
						path: 'tipos/vehiculos',
						name: 'settings-vehicle-types',
						component: UnderConstruction,
					},
					{
						path: 'tarifas',
						name: 'settings-fares',
						component: UnderConstruction,
					}
				]
			},
		]
	},
	{
		path: "/login",
		name: 'login',
		component: Login,
	}
]

export default routes;