@extends("reports.layout.layout")
@section("scripts")

@stop
@section("content")
    <style type="text/css">
        .table td {
            border-bottom-width: 0;
            padding: .25rem 1.25rem !important;
        }
    </style>
    <div class="box">
        @include('reports.layout.horizontal-header', ["title" => "Reporte de Movimientos Prepagos"])
        <div class="inbox mt-5 grid grid-cols-6 gap-6 p-2">
            <table class="table table-striped box">
                <tr>
                    <td>
                        <h2 class="text-base text-center mb-4">
                            <span class="font-bold">Desde:</span> {{ $data->from }}
                        </h2>
                        <h2 class="text-base text-center mb-4">
                            <span class="font-bold">Hasta:</span> {{ $data->to }}
                        </h2>
                        <h2 class="text-base text-center">
                            <span class="font-bold">Tipo de Movimiento:</span>
                            {{ ($data->credit) ? "Credito" : "" }}
                            {{ ($data->credit && $data->debit) ? " | " : "" }}
                            {{ ($data->debit) ? "Debito" : "" }}
                        </h2>
                    </td>
                    <td>
                        <h2 class="text-base text-center mb-4"><span class="font-bold">Placa:</span> {{ $data->plateSelected ?? "Todas" }}</h2>
                        <h2 class="text-base text-center mb-4"><span class="font-bold">Carnet:</span> {{ $data->cardSelected ?? "Todos" }}</h2>
                        <h2 class="text-base text-center"><span class="font-bold">Cliente:</span> {{ $data->profileSelected ?? "Todos" }}</h2>
                    </td>
                </tr>
            </table>
            <div class="flex flex-wrap justify-center align-center flex-col">

            </div>
        </div>
        <div class="inbox mt-5 grid grid-cols-12 gap-6">
            <table class="table table-striped box col-span-12">
                <thead>
                    <tr>
                        <th class="whitespace-nowrap" style="width: 120px;">Fecha</th>
                        <th class="whitespace-nowrap" style="width: 120px;">Hora</th>
                        <th class="whitespace-nowrap" style="width: 250px;">Carnet / Cliente</th>
                        <th class="whitespace-nowrap" style="width: 300px;">Referencia / Descripci&oacute;n</th>
                        <th class="whitespace-nowrap">Placa</th>
                        <th class="whitespace-nowrap">Tipo</th>
                        <th class="whitespace-nowrap">Monto Bs</th>
                        @if(isset($data->cardSelected))
                            <th class="whitespace-nowrap">Saldo Bs</th>
                        @endif
                    </tr>
                </thead>
                <tbody style="background-color: white;">
                    @foreach($data->rows as $key => $row)
                        @if($key % 2 == 0)
                        <tr style="background-color: #eee;">
                        @else
                        <tr style="background-color: #fff;">
                        @endif
                            <td style="width: 120px;">{{ trim($row->date) }}</td>
                            <td style="width: 120px;">{{ trim($row->time) }}</td>
                            <td  style="width: 120px;" class="truncate">
                                Carnet {{ trim($row->cardCode) }} <br />
                                {{ trim($row->client) }}
                            </td>
                            <td>
                                {{ trim($row->number) }}<br />
                                {{ trim($row->concept) }}
                                @if($row->cancel_concept)
                                    <br />
                                    <span style="color: red;">ANULADO: {{ trim($row->cancel_concept) }}</span>
                                @endif
                            </td>
                            <td style="max-width: 90px;">{{ trim($row->plate) }}</td>
                            <td style="max-width: 60px;">{{ trim($row->type) }}</td>
                            <td style="max-width: 60px;">{{ trim($row->ammount) }}</td>
                            @if(isset($data->cardSelected))
                                <td style="max-width: 60px;">{{ trim($row->new_balance) }}</td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</html>
