<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SpaController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\AnsapassController;
use App\Http\Controllers\VehicleController;
use App\Http\Controllers\PrepaidCardController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Barryvdh\Snappy\Facades\SnappyPdf;

use App\Models\Turn;
use App\Models\Takings;
use App\Models\Workstation;
use App\Models\Ansapass;
use App\Models\PrepaidSummary;
use App\Models\Vehicle;
use App\Models\PrepaidCard;
use App\Models\Profile;

use App\Events\SendMessage;
use App\Events\TagReaded;

use App\Jobs\SendReportJob;
use App\Jobs\RebuildPrepaidSummariesJob;
use App\Jobs\VerifyIfTakingHavePaymentJob;
use App\Jobs\CancelPrepaidSummaryJob;
use App\Jobs\ValidatePrepaidSummaryJob;
use App\Jobs\ValidatePrepaidCardMovementsJob;

use App\Jobs\SendRechargePrepaidSmsJob;
use App\Jobs\SendChargePrepaidSmsJob;

Route::get('test/report', function () {
	// $takings = Takings::whereBetween('created_at', ['2022-11-10 00:00:00', '2022-11-10 23:59:59'])
	// 					->orderBy('id', 'asc')
	// 					->get()
	// 					->toArray();

	// foreach ($takings as $taking) {
	// 	echo $taking['code'] . "</br>";
	// }

	$sql = "
        SELECT
                `takings`.`code`,
                `takings`.`vehicle_type_id`,
                `payments`.`amount`,
                `payments`.`payment_method_id`
        FROM
            `takings`,
            `paymentables`,
            `payments`

        WHERE `takings`.`created_at` BETWEEN '2022-11-10 00:00:00' AND '2022-11-10 23:59:59'
        AND `takings`.`id` = `paymentables`.`paymentable_id`
        AND `paymentables`.`payment_id` = `payments`.`id`
        AND `paymentables`.`paymentable_type` LIKE '%Takings'
        AND `takings`.`deleted_at` IS NULL
        ORDER BY `takings`.`id` asc;
    ";
    $takings = DB::select($sql);

    dd($takings[0]);

	foreach ($takings as $taking) {
		echo $taking->code . "</br>";
	}
});

Route::get('issue/2022-12-02', function () {
	$takings = Takings::where('turn_id', 960)
						->where('created_at', '>', '2022-12-02 00:00:00')
						->get();

	foreach ($takings as $taking) {
		echo $taking->created_at->format('d/m/Y') . "|";
		echo $taking->created_at->format('h:i:s') . "|";
		echo $taking->code . "|";
		echo $taking->amount . "</br>";
	}
});

Route::get('test/sms/recharge', function () {
	$profile = Profile::find(1);
	$summary = PrepaidSummary::find(19376);

	SendRechargePrepaidSmsJob::dispatch($profile, $summary);
});

Route::get('test/sms/charge', function () {
	$profile = Profile::find(1);
	$summary = PrepaidSummary::find(19378);

	SendChargePrepaidSmsJob::dispatch($profile, $summary);
});

Route::get('/reprint/prepaid/card', function () {
	$card = PrepaidCard::with('profile.documentType')->find(2081);
	return view('pdfcard', compact('card'));
});

Route::get('/find/duply/changes/v2', function () {
	$cards = PrepaidCard::all();
	foreach ($cards as $card) {
		ValidatePrepaidCardMovementsJob::dispatch($card);
	}

	// $summaries = PrepaidSummary::where('prepaid_card_id', 2081)
	// 						->where('prepaid_summaries.created_at', '>', '2022-09-31')
	// 						->join('takings', 'prepaid_summaries.code', '=', 'takings.code')
	// 						->select('prepaid_summaries.*', 'takings.vehicle_id', 'takings.turn_id')
	// 						->get();

	// return $summaries;
	// $last = new PrepaidSummary();
	// foreach ($summaries as $summary) {
	// 	if ($last->vehicle_id == $summary->vehicle_id
	// 		&& $last->amount == $summary->amount
	// 		&& $last->concept == $summary->concept
	// 		&& $last->turn_id == $summary->turn_id
	// 		&& $last->created_at > $summary->created_at->modify("-1 minutes")
	// 	) {
	// 		echo "REVISAR " . $last->id . ', ' . $summary->id . "<br />";
	// 	}
	// 	$last = $summary;
	// }
});

Route::get('/find/wrong/ansapass', function () {
	$ansapass = Ansapass::with('vehicle')->get();

	foreach ($ansapass as $ansa) {
		if ($ansa->vehicle->vehicle_type_id != 1) {
			echo "REVISAR PLACA " . $ansa->vehicle->plate . "<br />";
		}
	}

	return "Jobs dispatched";
});

Route::get('/prueba', function () {
	$prepaidSummaries = PrepaidSummary::where('type', 'out')->get();

	foreach ($prepaidSummaries as $summary) {
		ValidatePrepaidSummaryJob::dispatch($summary);
	}

	return "Jobs dispatched";
});

Route::get('/duply/prepaid/change', function () {
	$dateFrom  = '2022-09-01 00:00:00';
	$dateTo	   = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::whereBetween('created_at', [$dateFrom, $dateTo])
								->whereNull('cancel_concept')
								->whereNull('ansapass_id')
								// ->whereNotNull('ansapass_id')
								// ->whereNotNull('cancel_concept')
								->where('type', 'out')
								->get();
	$lastDate = null;
	$lastCardId = null;
	$lastAmmount = null;
	$cont = 1;
	foreach ($summaries as $summary) {
		if ($summary->prepaid_card_id == $lastCardId &&  $summary->amount == $lastAmmount) {
			if ($summary->created_at == $lastDate
				|| $summary->created_at == $lastDate->modify('+1 second')
				|| $summary->created_at == $lastDate->modify('+1 second')
				// || $summary->created_at == $lastDate->modify('+1 second')
			){
				echo $cont . ".- Revisar " . ($summary->id - 1) . ", " . ($summary->id). " | " . $summary->code . "<br />";
				$cont++;
				// echo "Revisar " . ($summary->id - 1) . " - " . $summary->code. "<br />";
				// CancelPrepaidSummaryJob::dispatch($summary->code, $originalCode);
				//
			}
		} else {
			$lastDate = $summary->created_at;
			$lastCardId = $summary->prepaid_card_id;
			$originalCode = $summary->code;
			$lastAmmount = $summary->amount;
		}
	}
});

Route::get('/find/ansapass/problems', function () {
	$dateFrom = '2022-10-01 00:00:00';
	$dateTo = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::with('ansapass', 'prepaidCard')
							->whereIn('id', [13023, 13024, 15902, 15903, 15908, 15909])
							// ->orderBy('id', 'asc')
							->get();
	$lastSummary = new PrepaidSummary();
	$lastPrinted = null;
	foreach ($summaries as $summary) {
		echo $summary->created_at->format('d-m-Y')."|";
		echo $summary->created_at->format('H:i:s')."|";
		echo $summary->code."|";
		echo $summary->prepaidCard->code."|";
		// echo $summary->ansapass->code."|";
		echo $summary->amount."|";
		echo $summary->cancel_concept;
		echo "<br />";
	}
});

Route::get('/print/possible/problems', function () {
	$dateFrom = '2022-10-01 00:00:00';
	$dateTo = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::with('ansapass', 'prepaidCard')
							->whereIn('id', [3783, 3786, 3786, 3788, 6448, 6449, 7801, 7802, 13504, 13505, 13840, 13842, 14384, 14385])
							// ->orderBy('id', 'asc')
							->get();
	$lastSummary = new PrepaidSummary();
	$lastPrinted = null;
	foreach ($summaries as $summary) {
		echo $summary->created_at->format('d-m-Y')."|";
		echo $summary->created_at->format('H:i:s')."|";
		echo $summary->code."|";
		echo $summary->prepaidCard->code."|";
		// echo $summary->ansapass->code."|";
		echo $summary->amount."|";
		echo $summary->cancel_concept;
		echo "<br />";
	}
});

Route::get('/find/ansapass/problems/2', function () {
	$dateFrom = '2022-10-01 00:00:00';
	$dateTo = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::with('ansapass', 'prepaidCard')
							->whereNull('cancel_concept')
							->whereIn('id', [266, 267, 665, 666, 1085, 1086, 1360, 1361, 1885, 1886, 1909, 1910, 1984, 1985, 2026, 2027, 2186, 2187, 2532, 2533, 2693, 2694, 2739, 2740, 2970, 2971, 3156, 3157, 3226, 3227, 3606, 3607, 3645, 3646, 4020, 4021, 4191, 4192, 4409, 4410, 4767, 4768, 5371, 5372, 5877, 5878, 6409, 6410, 6461, 6462, 6647, 6648, 6699, 6700, 8276, 8277, 8339, 8340, 8904, 8905, 9223, 9224, 9521, 9522, 9788, 9789, 9859, 9860, 10865, 10866, 11690, 11691, 11934, 11935, 12015, 12016, 13511, 13512, 13804, 13805, 14222, 14223, 14920, 14921, 15526, 15527, 15713, 15714, 17074, 17075, 17565, 17566, 17764, 17765, 17924, 17925])
							// ->orderBy('id', 'asc')
							->get();
	$lastSummary = new PrepaidSummary();
	$lastPrinted = null;
	foreach ($summaries as $summary) {
		echo $summary->created_at->format('d-m-Y')."|";
		echo $summary->created_at->format('H:i:s')."|";
		echo $summary->code."|";
		echo $summary->prepaidCard->code."|";
		echo $summary->ansapass->code."|";
		echo $summary->amount."|";
		echo $summary->cancel_concept;
		echo "<br />";
	}
});

Route::get('/find/prepaid/cards/problems', function () {
	$dateFrom = '2022-10-01 00:00:00';
	$dateTo = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::with('ansapass', 'prepaidCard')
							->whereIn('id', [4354, 4355, 11017, 11018, 12058, 12059, 13022, 13023, 13589, 13590, 13956, 13957, 15360, 15361, 15486, 15487, 15487, 15488, 15559, 15560, 15818, 15819, 15834, 15835, 15867, 15868, 16889, 16890, 16999, 17000, 15652, 15653, 15811, 15812])
							// ->orderBy('id', 'asc')
							->get();
	$lastSummary = new PrepaidSummary();
	$lastPrinted = null;
	foreach ($summaries as $summary) {
		echo $summary->created_at->format('d-m-Y')."|";
		echo $summary->created_at->format('H:i:s')."|";
		echo $summary->code."|";
		echo $summary->prepaidCard->code."|";
		echo $summary->concept."|";
		echo $summary->amount."|";
		echo $summary->cancel_concept;
		echo "<br />";
	}
});


Route::get('/duply/ansapass', function () {
	$dateFrom = '2022-10-01 00:00:00';
	$dateTo = '2022-11-30 23:59:59';
	$summaries = PrepaidSummary::with('ansapass', 'prepaidCard')
							->whereNotNull('ansapass_id')
							->whereBetween('created_at', [$dateFrom, $dateTo])
							// ->whereNull('cancel_concept')
							// ->orderBy('id', 'asc')
							->get();
	$lastSummary = new PrepaidSummary();
	$lastPrinted = null;
	foreach ($summaries as $summary) {
		// echo $summary->created_at->format('Y-m-d h:i:s') . ' -> ' . $summary->code  . '-' . $summary->ansapass_id;
		if($summary->ansapass_id == $lastSummary->ansapass_id){
		// if($summary->ansapass_id == $lastSummary->ansapass_id){
			// CancelPrepaidSummaryJob::dispatch($summary->code, $originalCode);
			if($lastPrinted != $summary->ansapass_id ){
				$lastPrinted = $summary->ansapass_id;
				echo $lastSummary->created_at->format('d-m-Y')."|";
				echo $lastSummary->created_at->format('H:i:s')."|";
				echo $lastSummary->code."|";
				echo $lastSummary->prepaidCard->code."|";
				echo $lastSummary->ansapass->code."|";
				echo $lastSummary->amount;
				echo "<br />";
				// echo "<span style='color:red; font-weigh: 600; margin-left:30px'>duply " . $lastSummary->id . "</span><br />";
			}

			echo $summary->created_at->format('d-m-Y')."|";
			echo $summary->created_at->format('H:i:s')."|";
			echo $summary->code."|";
			echo $summary->prepaidCard->code."|";
			echo $summary->ansapass->code."|";
			echo $summary->amount."|";
			echo "ANULADO: Movimiento " . $lastSummary->code . " Duplicado";
			echo "<br />";
			// echo "<span style='color:red; font-weigh: 600; margin-left:30px'>duply " . $summary->id . "</span><br />";
		} else {
			$lastSummary = $summary;
		}
	}
});

Route::get('/count/takings', function () {
	$dateFrom = '2022-11-12 00:00:00';
	$dateTo = '2022-11-12 23:59:59';
	$takings = Takings::whereBetween('created_at', [$dateFrom, $dateTo])->get();
	return $takings->count();
});



Route::get('/verify/takings/witouth/payments', function() {
	$takings = Takings::with('payments')->where('id', '>', 500000)->take(50000)->get()->toArray();

	foreach ($takings as $taking) {
		VerifyIfTakingHavePaymentJob::dispatch($taking);
	}
	return "Jobs dispatched";

	// $withoutPayments = [];

	// foreach ($data as $taking) {
	// 	if (count($taking["payments"]) == 0) {
	// 		$withoutPayments[] = $taking;
	// 	}
	// }

	// return response()->json($withoutPayments);
});

Route::get('rebuild/prepaid/card/balances', function () {
	// $cards = PrepaidCard::all();
	// foreach ($cards as $card) {
	// 	RebuildPrepaidSummariesJob::dispatch($card);
	// }
});

Route::get('test', function() {
	$profile = Profile::find(1);
	$summary = PrepaidSummary::find(1);

	SendChargePrepaidSmsJob::dispatch($profile, $summary);
});