<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title></title>
	<style type="text/css">
		.card-front {
			background-image: url(<?php echo e(asset("assets/card-front.png")); ?>); /* The image used */
			background-color: #fff; /* Used if the image is unavailable */
			width: 333px; /* You must set a specified height */
			height: 208px; /* You must set a specified height */
			background-position: center; /* Center the image */
			background-repeat: no-repeat; /* Do not repeat the image */
			background-size: contain; /* Resize the background image to cover the entire container */
			float: left;
			position: relative;
			border: 1px solid;
		}

		/*
			.card-front .name {
				position: absolute;
				bottom: 20px;
				right: 20px;
				font-weight: 800;
				max-width: 185px;
				overflow: hidden;
				white-space: pre;
				font-size: 12px;
				color: #393737;
			}

			.card-front .code {
				position: absolute;
				bottom: 65px;
				left: 15px;
				font-size: 22px;
				font-weight: 600;
			}
		*/

		.card-back {
			background-color: #ffffff; /* Used if the image is unavailable */
			width: 333px; /* You must set a specified height */
			height: 208px; /* You must set a specified height */
			background-position: center; /* Center the image */
			background-repeat: no-repeat; /* Do not repeat the image */
			background-size: contain; /* Resize the background image to cover the entire container */
			float: left;
			position: relative;
			border-top: 1px solid;
			border-right: 1px solid;
			border-bottom: 1px solid;
		}

		.card-back .barcode {
			position: absolute;
			top: 95px;
			left: 40px;
		}

		.card-back .code {
			position: absolute;
			left: 0px;
			bottom: 10px;
			color: #393737;
			width: 333px;
			text-align: center;
			font-weight: 800;
		}

		.card-back .name {
			position: absolute;
			top: 40px;
			left: 0px;
			width: 333px;
			text-align: center;
			overflow: hidden;
			font-size: 12px;
			white-space: pre;
		}

		.card-back .password {
			position: absolute;
			right: 53px;
			top: 105px;
			text-align: center;
		}
		.card-back .document {
			position: absolute;
			top: 65px;
			left: 0;
			width: 333px;
			text-align: center;
			font-size: 14px;
		}

		.card-back .logo-gobernacion {
			position: absolute;
			width: 90px;
			top: 5px;
			left: 5px;
		}

		.card-back .title {
			position: absolute;
			top: 5px;
			left: 120px;
			font-size: 0.45rem;
			text-align: center;
		}

	</style>
</head>
<body style="max-width: 900px; padding: 100px 0 0 40px;">
	<div class="card-front">

	</div>
	<div class="card-back">
		<img src="<?php echo e(asset("assets/gobernacion.png")); ?>" class="logo-gobernacion">
		<span class="title">
			Sistema Automatizado Para Flujo Vial<br />
			Tarjeta válida solo en el Estado Lara
		</span>
		<span class="name"><?php echo e($card->profile->names); ?> <?php echo e($card->profile->surnames ?? ""); ?></span>
		<span class="code"><?php echo e($card->code); ?></span>
		<div class="barcode"><?php echo DNS1D::getBarcodeHTML($card->code, 'C128',1.5 ,70); ?> </div>
		<span class="document"><?php echo e($card->profile->documentType->letter); ?>-<?php echo e($card->profile->id_card); ?></span>
		<span class="code"><?php echo e($card->code); ?></span>
		<span class="password">
			Clave:<br/>
			<?php echo e($card->password); ?>

		</span>
	</div>
	
</body>
</html><?php /**PATH C:\xampp\htdocs\sigep-core\resources\views/pdfcard.blade.php ENDPATH**/ ?>